// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "uniformWorldConstants.h"
#include "uniformShaderConstants.h"
#include "fragmentVersionSimple.h"
#include "uniformPerFrameConstants.h"
#include "lib/Hash.h"

/////////////////////////////////////////////////////////////////
///////////////////////// STOP! /////////////////////////////////
/////////////////////////////////////////////////////////////////
// Made by @Bicubicpack.
// successfully changed (modified and optimalized) on 7 oct 2020.
// all of these assets are under MIT license.
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

varying highp vec3 pos;

highp float drawcloud(highp vec2 pos,float value){
	float tot = 0.,s= 1.1;
	highp vec2 ptime = TIME*vec2(-2.,1.3);
		pos += ptime*0.008;

	for(int i = 0; i < 4; i++){
		tot += noise(pos)*1.*value/s; s *= 2.2;
		pos *= 2.5;
		pos += ptime*0.01;
	}
return 1.-pow(.1,max(1.-tot,0.));
}

vec4 renderclouds(highp vec2 pos,highp vec3 rpos,float py){
    vec3 tot = vec3(1.3,1.3,1.3);
	float rain = (1.-pow(FOG_CONTROL.y,10.));
	highp float value = mix(2.,1.2,rain), a = .0;
	vec3 scolor = FOG_COLOR.rgb*1.3;
		pos *= 1.2;

	for(int i = 0; i < 10; i++){
		float denc = drawcloud(pos, value);
		value /= 1.07; pos /= 1.03;

		if(denc > 0.0){
			float night = pow(max(min(1.-FOG_COLOR.r*1.5,1.),.0),1.2);
			float dusk = (1.-FOG_COLOR.b)*clamp((FOG_COLOR.r-.15)*1.25,0.,1.);

			vec3 cloudcolorc = mix(vec3(1.,1.,1.),vec3(.2,.4,.8)*0.8,night);
				cloudcolorc = mix(cloudcolorc,vec3(1.1,.8,1.)*1.2,dusk);
				cloudcolorc = mix(cloudcolorc, FOG_COLOR.rgb*1.5,rain);
				cloudcolorc = mix(cloudcolorc*1.6,scolor*denc,denc);
			tot = mix(tot,cloudcolorc,denc);
			a += mix(0.,(1.5-denc*0.4)*(1.-a),denc);
		}

		scolor /= 1.087;
	}
	
	vec4 result = vec4(tot,a);
	float ys = clamp(py, 0.0, 0.8) * 2.5 + 0.7;
		result.a = mix(result.a, 0.0, min(pow(ys, 9.0), 1.0));
		result = vec4(result.rgb, clamp((result.a-0.6)*1.1, 0.0, 1.0)) * result.a;
return result;
}

void main(){
	vec3 po = pos/(pos.y-0.14);
	vec4 cloud = renderclouds(vec2(-po.x,po.z)*1.5,po,pos.y);
gl_FragColor = cloud;

}
